--
-- Create/Update stored procedure
--

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_EFR_GetDoDFragmentFiles]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_EFR_GetDoDFragmentFiles]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

-- ===============================================
-- Author:		Atlee Whiteleather
-- Create date: 12/05/2013
-- Description:	Use to populate the DoD Fragment
--              File listing page
-- ===============================================

CREATE PROCEDURE [dbo].[usp_EFR_GetDoDFragmentFiles]
	 @orderBy varchar(50) -- Column name, matched c# code
	,@sortOrder varchar(50) -- 'Ascending' or 'Descending'
	,@filter varchar(2000)
AS
BEGIN
	SELECT  DOD_FRAGMENT_RAW_DATA_ID, 
			SOURCE_LAB, 
			ORIGINAL_NAME, 
			CONTENT_TYPE, 
			CREATED,
			[dbo].[GetEFRNumberOfPatientsInDoDFragmentFile](DOD_FRAGMENT_RAW_DATA_ID) as 'NUMBER_OF_PATIENTS',
			[dbo].[GetEFRNumberOfRecordsInDoDFragmentFile](DOD_FRAGMENT_RAW_DATA_ID) as 'NUMBER_OF_RECORDS'
			
	FROM         EFR.DOD_FRAGMENT_RAW_DATA
	where SOURCE_LAB not like 'GOLD%' 
	and [dbo].[GetEFRNumberOfPatientsInDoDFragmentFile](DOD_FRAGMENT_RAW_DATA_ID) > 0
	and SOURCE_LAB like
		case when (LEN(@filter) > 0) then
			'%' + @filter + '%'
		else
			'%'
		end
	order by 
	
		CASE WHEN @orderBy = 'SOURCE_LAB' AND @sortOrder = 'Ascending' 
			 THEN SOURCE_LAB END asc,
		CASE WHEN @orderBy = 'SOURCE_LAB' AND @sortOrder = 'Descending' 
			 THEN SOURCE_LAB END desc,
	
		CASE WHEN @orderBy = 'CREATED' AND @sortOrder = 'Ascending' 
			 THEN CREATED  END asc,
		CASE WHEN @orderBy = 'CREATED' AND @sortOrder = 'Descending' 
			 THEN CREATED END desc
END
GO

--
-- Insert STD_APPAGE record
--

if (select count(ID) 
    from STD_APPPAGE
    where code = 'EFR_DODFRAGMENT_REPORT') = 0
begin
	insert into STD_APPPAGE  
	(CODE, NAME, DESCRIPTION_TEXT, SORT_ORDER, INACTIVE_FLAG, INACTIVE_DATE, 
	 CREATEDBY, UPDATEDBY, CREATED, UPDATED)
	 values
	('EFR_DODFRAGMENT_REPORT', 'EFR_DODFRAGMENT_REPORT', 'EFR_DODFRAGMENT_REPORT', 1, 0, null, 'vaaitcwhitea',
	 'vaaitcwhitea', getdate(), getdate())
end

declare @apppageid int
select  @apppageid = ID
from STD_APPPAGE 
where CODE = 'EFR_DODFRAGMENT_REPORT'

if (select COUNT(ID)
	from ROLE_PERMISSIONS rp
	inner join STD_APPPAGE sa on sa.ID = rp.STD_APPPAGE_ID
	where sa.CODE = 'EFR_DODFRAGMENT_REPORT') = 0
begin
	insert into ROLE_PERMISSIONS 
	(STD_ROLE_ID, STD_APPPAGE_ID, CREATEDBY, UPDATEDBY, CREATED, UPDATED, INSERT_FLAG, 
     UPDATE_FLAG, DELETE_FLAG)
	values
	(4, @apppageid, 'vaaitcwhitea', 'vaaitcwhitea', GETDATE(), GETDATE(), 0, 1, 0)
end

--
-- Create helper functions
--

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetEFRNumberOfPatientsInDoDFragmentFile]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION [dbo].[GetEFRNumberOfPatientsInDoDFragmentFile]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE FUNCTION [dbo].[GetEFRNumberOfPatientsInDoDFragmentFile](
 @DOD_FRAGMENT_RAW_DATA_ID int
)
RETURNS int
AS
BEGIN
	declare @result int
	
	set @result = 0
	set @result = 
		(SELECT     count(distinct fdr.patientssn)
		 FROM EFR.DoD_FRAGMENT_DATA_RECEIVELOG fdr
		 inner join efr.DOD_FRAGMENT_RAW_DATA frd on frd.DOD_FRAGMENT_RAW_DATA_ID = fdr.DOD_FRAGMENT_RAW_DATA_ID
		 where frd.DOD_FRAGMENT_RAW_DATA_ID = @DOD_FRAGMENT_RAW_DATA_ID)

	return @result
END
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetEFRNumberOfRecordsInDoDFragmentFile]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION [dbo].[GetEFRNumberOfRecordsInDoDFragmentFile]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE FUNCTION [dbo].[GetEFRNumberOfRecordsInDoDFragmentFile](
 @DOD_FRAGMENT_RAW_DATA_ID int
)
RETURNS int
AS
BEGIN
	declare @result int
	
	set @result = 0
	set @result = 
		(SELECT     count(fdr.patientssn)
		 FROM EFR.DoD_FRAGMENT_DATA_RECEIVELOG fdr
		 inner join efr.DOD_FRAGMENT_RAW_DATA frd on frd.DOD_FRAGMENT_RAW_DATA_ID = fdr.DOD_FRAGMENT_RAW_DATA_ID
		 where frd.DOD_FRAGMENT_RAW_DATA_ID = @DOD_FRAGMENT_RAW_DATA_ID)

	return @result
END
Go

INSERT INTO [dbo].[DatabaseChangeLog]
           ([MajorReleaseNumber]
           ,[MinorReleaseNumber]
           ,[PointReleaseNumber]
           ,[Hotfix]
           ,[ScriptName]
           ,[ScriptDescription]
           ,[TargetRegistry]
           ,[DateApplied])
     VALUES
           ('R6'
           ,'00'
           ,'001'
           ,0
           ,'20757  Develop Remaining Standard Reports not Implemented'
		   ,'Script will setup for the new DoD Fragment File report'
           ,'EFR'
           ,GETDATE())

GO
